#include <np.h>
#include <string>


#include "UnityNP.h"
#include "ErrorCodesSony.h"
#include "NetCtlStatus.h"

#if	NP_HAS_ERROR_CODES
 #include "ErrorCodesSony.h"
#endif
#include "toolkit.h"
#include "MessagePipe.h"
#include "SignInSony.h"
#include "UserProfileSony.h"
#if NP_HAS_BANDWIDTH
 #include "NetInfo.h"
#endif
#if NP_HAS_FRIENDS_LIST
 #include "FriendsListSony.h"
#endif
#if	NP_HAS_ONLINE_PRESENCE
 #include "OnlinePresenceSony.h"
#endif
#if	NP_HAS_TROPHIES
 #include "TrophiesSony.h"
#endif
#if	NP_HAS_RANKING
 #include "RankingSony.h"
#endif
#if	NP_HAS_MATCHING
 #include "MatchingSony.h"
#endif
#if	NP_HAS_WORD_FILTER
 #include "WordFilterSony.h"
#endif
#if	NP_HAS_MESSAGING
 #include "MessagingSony.h"
#endif
#if	NP_HAS_TUSTSS
 #include "TusTssSony.h"
#endif
#if	NP_HAS_COMMERCE
 #include "CommerceSony.h"
#endif
#if	NP_HAS_NP_DIALOGS
 #include "NpDialogsSony.h"
#endif
#if	NP_HAS_NP_FACEBOOK
#include "FacebookSony.h"
#endif
#if NP_HAS_TWITTER
#include "TwitterSony.h"
#endif
#if NP_HAS_TICKETING
#include "Ticketing.h"
#endif
#if NP_HAS_INVITES
#include "Invites.h"
#endif
#if NP_HAS_NP_REQUESTS
#include "NpAsyncRequests.h"
#endif

using namespace sce::Toolkit::NP;
using namespace sce::Toolkit::NP::Utilities;
using namespace UnityPlugin;

bool gInitialized = false;
unsigned int gCreationFlags = 0;
static	bool	bIsShuttingDown = false;


bool	IsShuttingDown( void )
{
	return	bIsShuttingDown;
}

void	SetShutDown( void )
{
	bIsShuttingDown = true;
}

void myNpToolkitCallback(const sce::Toolkit::NP::Event& event)
{
	if( IsShuttingDown() )
	{
		return;
	}
	
	switch(event.service)
	{
	case core:
		UNITY_TRACE("Received core callback %d\n",event.event);

		switch(event.event)
		{
			case Event::enetDown:
				// Do nothing (Vita & PS4), this event is now handled by NetCtlStatusCallback() which can be found in NetCtlStatus.cpp
				// On PS3 this still needs looking into, the callback code doesn't seem to work.
				UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_ConnectionDown);
				break;

			case Event::enetUp:
				UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_ConnectionUp);
				break;

			case Event::loggedIn:
				UnityPlugin::gSignedInState.ProcessEvent(event);;
				break;

			case Event::loggedOut:
				UnityPlugin::gSignedInState.ProcessEvent(event);;
				break;

			default:
				DBG_LOG_WARNING("core service event not handled: %d", event.event);
				break;
		}
		break;

	case netInfo:
#if NP_HAS_BANDWIDTH
		if(UnityPlugin::gNetInfo.ProcessEvent(event)) return;
#endif
		if(UnityPlugin::gSignedInState.ProcessEvent(event)) return;
		DBG_LOG_WARNING("netInfo service event not handled: %d", event.event);
		break;

#if NP_HAS_FRIENDS_LIST
	case friends:
		if(UnityPlugin::gFriendsList.ProcessEvent(event)) return;
		DBG_LOG_WARNING("friends service event not handled: %d", event.event);
		break;
#endif
#if NP_HAS_MATCHING
	case matching:
		if(UnityPlugin::gMatching.ProcessEvent(event)) return;
		DBG_LOG_WARNING("matching service event not handled: %d", event.event);
		break;
#endif
	case profile:
		if(UnityPlugin::gUserProfile.ProcessEvent(event)) return;
		DBG_LOG_WARNING("profile service event not handled: %d", event.event);
		break;

#if NP_HAS_TROPHIES
	case trophy:
		if(UnityPlugin::gTrophies.ProcessEvent(event)) return;
		DBG_LOG_WARNING("trophy service event not handled: %d", event.event);
		break;
#endif
#if NP_HAS_RANKING
	case ranking:
		if(UnityPlugin::gRanking.ProcessEvent(event)) return;
		DBG_LOG_WARNING("ranking service event not handled: %d", event.event);
		break;
#endif
#if NP_HAS_ONLINE_PRESENCE
	case presence:
		if(UnityPlugin::gPresence.ProcessEvent(event)) return;
		DBG_LOG_WARNING("presence service event not handled: %d", event.event);
		break;
#endif
#if NP_HAS_WORD_FILTER
	case wordFilter:
		if(UnityPlugin::gWordFilter.ProcessEvent(event)) return;
		DBG_LOG_WARNING("wordfilter service event not handled: %d", event.event);
		break;
#endif
#if NP_HAS_COMMERCE
	case commerce:
		if(UnityPlugin::gCommerce.ProcessEvent(event)) return;
		DBG_LOG_WARNING("commerce service event not handled: %d", event.event);
		break;
#endif

	case auth:
		// PS3 npToolkit uses the auth service events for entitlements.
		// NOTE: auth is used by commerce and tickets on PS3, so if ticketing is busy skip the commerce event processing.
		if(!UnityPlugin::gTicketing.IsBusy())
		{
			if(UnityPlugin::gCommerce.ProcessEvent(event)) return;
		}

#if NP_HAS_TICKETING
		if(UnityPlugin::gTicketing.ProcessEvent(event)) return;
#endif

		DBG_LOG_WARNING("auth service event not handled: %d", event.event);
		break;

#if NP_HAS_NP_FACEBOOK
	case sns:
		if(UnityPlugin::gFacebook.ProcessEvent(event)) return;
		DBG_LOG_WARNING("sns service event not handled: %d", event.event);
		break;
#endif

#if NP_HAS_MESSAGING
	case messaging:
		if(UnityPlugin::gMessaging.ProcessEvent(event)) return;
		DBG_LOG_WARNING("messaging service event not handled: %d", event.event);
		break;
#endif




#if NP_HAS_NEAR
	case near:
		DBG_LOG_WARNING("near service event not handled: %d", event.event);
		break;
#endif

#if NP_HAS_TUSTSS
	case tss:
		if(UnityPlugin::gTusTss.ProcessEvent(event)) return;
		DBG_LOG_WARNING("tss service event not handled: %d", event.event);
		break;

	case tus:
		if(UnityPlugin::gTusTss.ProcessEvent(event)) return;
		DBG_LOG_WARNING("tus service event not handled: %d", event.event);
		break;
#endif

	default:
		DBG_LOG_WARNING("unknown service event not handled: %d", event.event);
		break;
	}
}


int InitializeToolkitPS3(unsigned int creationFlags, int npAgeRating)
{
	int ret = 0 ;

	SceNpCommunicationId*			commID = (SceNpCommunicationId*)gAppInfo.m_NpCommunicationId;
	SceNpCommunicationPassphrase*	commPass = (SceNpCommunicationPassphrase*)gAppInfo.m_NpCommunicationPassphrase;
	SceNpCommunicationSignature*	commSig = (SceNpCommunicationSignature*)gAppInfo.m_NpCommunicationSignature;
	Assert(commID);
	Assert(commPass);
	Assert(commSig);
	sce::Toolkit::NP::CommunicationId id(*commID, *commPass, *commSig);

	sce::Toolkit::NP::Parameters params(myNpToolkitCallback, id);

	params.m_commerceServiceId = s_serviceId;
	params.m_ticketingServiceId = s_serviceId;

	params.m_ageRating = (npAgeRating >= 0) ? npAgeRating : gAppInfo.m_NpAgeRating;
	params.m_trial = gAppInfo.m_Trial;

	ret = sce::Toolkit::NP::Interface::init(params);
	if (ret < 0 )
	{
		UnityPlugin::Messages::LogError("NP Toolkit init failed, ret = 0x%x\n", ret);
		return ret;
	}

#if	NP_HAS_TROPHIES
	if(gAppInfo.m_NpHasTrophyPack)
	{
		UnityPlugin::gTrophies.RegisterTrophyPack((creationFlags & kNpToolkitCreate_CacheTrophyIcons) != 0);
	}
#endif
	//	Even when there are trophies, send the NPInitialized message immediately to let other components be available
	//	Titles WITH Trophies can query Sony.NP.Trophies.TrophiesAreAvailable and/or catch the kNPToolKit_TrophySetSetupSuccess message
	UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_NPInitialized);
	gInitialized = true;
	return ret;
}



int InitializeToolkit(unsigned int creationFlags, int npAgeRating)
{
	if(gInitialized)
	{
		UnityPlugin::Messages::LogWarning("NP Toolkit already initialized\n");
		return 0;
	}

	gCreationFlags = creationFlags;

	RegisterNetCtlStatusCallback();

	return InitializeToolkitPS3(creationFlags, npAgeRating);
}

void	ShutDownToolkit( void )
{
	if( IsShuttingDown() )
	{
		return;
	}
	SetShutDown();

	printf("Shutting down NPToolkit...\n");
	sce::Toolkit::NP::Interface::terminate();
}



void Update()
{
	if( IsShuttingDown() )
	{
		return;
	}
	

	UnityPlugin::gUserProfile.Update();

#if	NP_HAS_MESSAGING
	UnityPlugin::gMessaging.Update();
#endif
#if	NP_HAS_NP_DIALOGS
	UnityPlugin::gNpDialogs.Update();
#endif
#if	NP_HAS_TWITTER
	UnityPlugin::gTwitter.Update();
#endif
#if	NP_HAS_NP_COMMERCE
	UnityPlugin::gCommerce.Update();
#endif
#if	NP_HAS_INVITES
	UnityPlugin::gInvites.Update();
#endif
#if NP_HAS_NP_REQUESTS
	UnityPlugin::gRequests.Update();
#endif
}


PrxPluginArgs gAppInfo; 


